def getCombos(chars, k, indent=0):
    debugMsg = '.' * indent + "Jestem wewnątrz getCombos('" + chars + "', " + str(k) + ")"
    print(debugMsg + ', start.')
    if k == 0:
        # PRZYPADEK BAZOWY
        print(debugMsg + " przypadek bazowy. Zwracam  [''].")
        return ['']  # Jeżeli k jest zerem zwracam łańcuch '' reprezentujący wybór zera liter z przekazanego łańcucha.
    elif chars == '':
        # PRZYPADEK BAZOWY
        print(debugMsg + ' przypadek bazowy. Zwracam  [].')
        return []  # Pusty znak nie ma żadnych kombinacji, niezależnie od wartości k.

    # PRZYPADEK REKURENCYJNY
    combinations = []
    # Część pierwsza: poszukiwanie kombinacji z uwzględnieniem głowy:
    head = chars[:1]
    tail = chars[1:]
    print(debugMsg + " część 1, szukam kombinacji z głową '" + head + "'")
    tailCombos = getCombos(tail, k - 1, indent + 1)
    print('.' * indent + "Dodaję głowę '" + head + "' do kombinacji ogona:")
    for tailCombo in tailCombos:
        print('.' * indent + 'Nowa kombinacja', head + tailCombo)
        combinations.append(head + tailCombo)

    # Część druga: poszukiwanie kombinacji z pominięciem głowy:
    print(debugMsg + " część 2, szukam kombinacji bez głowy '" + head + "')")
    combinations.extend(getCombos(tail, k, indent + 1))

    print(debugMsg + ' otrzymałem', combinations)
    return combinations

def getPowerSet(chars):
    powerSet = []
    for i in range(len(chars) + 1):
        powerSet.extend(getCombos(chars, i))
    return powerSet

print('Zbiór potęgowy "ABC":')
print('Wyniki:', getPowerSet('ABC'))
